#include "paradiz.h"

void Paradiz::initPartie()
{
    int iX=150;
    if ( g_SGEntite.getSizeListe() > 0 )
    {
        g_SGEntite.debut();
        do
        {
             if ( g_SGEntite.getCourant()->getPhysicData() != NULL )
                  if ( g_SGEntite.getCourant()->getPhysicData()->getBouge() )
                  {
                       g_SGEntite.getCourant()->setX(iX);
                       g_SGEntite.getCourant()->setY(484);
                       g_SGEntite.getCourant()->init();
                       g_SGEntite.getCourant()->getNom();
                       if ( g_pJeu->getModeJeu() == MULTI )
                       {
                           Joueur *pJ=(Joueur*)g_SGEntite.getCourant();
                           g_SGEntite.getCourant()->getSprite()->changeColor(0,0,0,9,15,pJ->getNumJoueur()*65000/8);
                           g_SGEntite.getCourant()->getSprite()->changeColor(2,0,1,9,37,pJ->getNumJoueur()*65000/8-1000);
                       }
                       iX+=50;
                  }
        } while( g_SGEntite.suivant() );
    }
    
    g_SGEntite.get("porte")->getSprite()->changerEtat(0);

    if ( g_SGEntite.getSizeListe() > 0 )
    {
        g_SGEntite.debut();
        while ( g_SGEntite.getRang("brique") != -1 )
                g_SGEntite.del("brique");
    }    

    if ( g_SGEvent.getSizeListe() > 0 )
    {
        g_SGEvent.debut();
        do
        {
             if ( strcmp(g_SGEvent.getNomCourant(),"quitter") != 0 )
                 g_SGEvent.getCourant()->Off();
        } while( g_SGEvent.suivant() );
    }
    
    g_SGTimer.add("debut",3000);
    g_SGEvent.add(new ClassicEvent<SGEvent,Paradiz> (&g_SGEvent,&SGEvent::toujours,this,&Paradiz::updateDebut),"Debut");
    g_SGEntite.add("getready",SCREEN_W/2-150,SCREEN_H/2-50,"./images/getready.bmp");
}

void Paradiz::updateDebut()
{
    if ( g_SGTimer.get("debut")->pret() )
    {
        if ( g_SGEvent.getSizeListe() > 0 )
        {
         g_SGEvent.debut();
         do
         {
                 g_SGEvent.getCourant()->On();
         } while( g_SGEvent.suivant() );
        }
        g_SGTimer.del("debut");
        g_SGEvent.del("Debut");
        g_SGEntite.del("getready");
        
        g_SGTimer.add("go",1500);
        g_SGEvent.add(new ClassicEvent<SGEvent,Paradiz> (&g_SGEvent,&SGEvent::toujours,this,&Paradiz::updateGo),"go");
        g_SGEntite.add("go",SCREEN_W/2-50,SCREEN_H/2-50,"./images/go.bmp");
    }
}

void Paradiz::updateGo()
{
    if ( g_SGTimer.get("go")->pret() )
    {
        g_SGTimer.del("go");
        g_SGEvent.del("go");
        g_SGEntite.del("go");
        
    }
}

void Paradiz::finPartie()
{
    if ( g_SGEvent.getSizeListe() > 0 )
    {
        g_SGEvent.debut();
        do
        {
                if ( strcmp(g_SGEvent.getNomCourant(),"quitter") != 0 )
                    g_SGEvent.getCourant()->Off();
        } while( g_SGEvent.suivant() );
    }
    
    g_SGEntite.add("winner",SCREEN_W/2-150,SCREEN_H/2-50,"./images/winner.bmp");
    g_SGTimer.add("winner",3000);
    g_SGEvent.add(new ClassicEvent<SGEvent,Paradiz> (&g_SGEvent,&SGEvent::toujours,this,&Paradiz::updateFin),"winner");
}

void Paradiz::updateFin()
{
    if ( g_SGTimer.get("winner")->pret() ) 
    {
        g_SGTimer.del("winner");
        g_SGEvent.del("winner");
        g_SGEntite.del("winner");
        initPartie();
    }
}

void Paradiz::afficherScore()
{
    Joueur *pJ;
    int iY=0;
    g_SGFichier.ouvrir("config.cfg");
    g_SGFichier.charger();
    if ( g_SGEntite.getSizeListe() > 0 )
    {
        g_SGEntite.debut();
        do
        {
             if ( g_SGEntite.getCourant()->getPhysicData() != NULL )
                  if ( g_SGEntite.getCourant()->getPhysicData()->getBouge() )
                  {
                       pJ=(Joueur*)g_SGEntite.getCourant();
                       Chaine ch(pJ->getNom());
                       if ( g_pJeu->getModeJeu() == MULTI )
                       {
                           g_SGAffichage.afficherTexte(ch+" :",SCREEN_W-150,20+iY,pJ->getNumJoueur()*65000/8);
                           g_SGAffichage.afficherEntier(pJ->getScore(),SCREEN_W-30,20+iY,pJ->getNumJoueur()*65000/8);
                       }
                       else
                       {
                         if ( pJ->getNumJoueur() == 1 )
                         {
                           g_SGAffichage.afficherTexte(ch+" :",SCREEN_W-150,20+iY,g_SGFichier.lire("Couleur"));
                           g_SGAffichage.afficherEntier(pJ->getScore(),SCREEN_W-30,20+iY,g_SGFichier.lire("Couleur"));
                         }
                         else
                         {
                           g_SGAffichage.afficherTexte(ch+" :",SCREEN_W-150,20+iY,g_SGFichier.lire("Couleur2"));
                           g_SGAffichage.afficherEntier(pJ->getScore(),SCREEN_W-30,20+iY,g_SGFichier.lire("Couleur2"));
                         }
                       }
                       iY+=10;
                  }
        } while( g_SGEntite.suivant() );
    }
    g_SGFichier.fermer();
}
